/*
 * QrfeGenericTag.cpp
 *
 *  Created on: 31.07.2012
 *      Author: stefan.detter
 */

#include "../inc/tag/QrfeGenericTag.h"


QrfeGenericTag::QrfeGenericTag(QString tagId, QrfeTagManipulatorInterface* reader, QObject* parent)
	: QrfeTagInterface(tagId, reader, parent)
{

}

QrfeGenericTag::~QrfeGenericTag()
{
}


QrfeGlobal::TMIResult QrfeGenericTag::readInformations()
{
	m_manufacturer = "Unknown";
	m_model = "Unknown";
	m_userMemSize = 0;
	m_serialNumber = 0;
	return QrfeGlobal::TMI_OK;
}

QrfeGlobal::TMIResult QrfeGenericTag::readFromTag ( uchar mem_bank, ushort address, QByteArray passwd, uchar count, QByteArray &data )
{
	return m_reader->readFromTag(m_tagId, mem_bank, address, passwd, count, data);
}

QrfeGlobal::TMIResult QrfeGenericTag::writeToTag ( uchar mem_bank, ushort address, QByteArray passwd, QByteArray data )
{
	return m_reader->writeToTag(m_tagId, mem_bank, address, passwd, data);
}



